%  Please do not remove the following comments when disseminating the program
%  Please consider to cite our paper if you use the program:
%  Wei E.I. Sha, Xingang Ren, Luzhou Chen, and Wallace C.H. Choy, 
% The Efficiency Limit of CH3NH3PbI3 Perovskite Solar Cells, 
%  AIP, Applied Physics Letters, vol. 106, no. 22, pp. 221104, Jun. 2015.

%  The program was written by Wei E.I. Sha
%  Email: wsha@eee.hku.hk  dr.weisha@gmail.com

function [JJ]=limit_solar(L,V,cuoff_wavelength1)

% define units
ref_m=10^(9);                  %  nm 
ref_s=10^15;                   %  ps
ref_V=1;                       %  1V
ref_C=1/(1.60217657*10^(-19)); %  elementary charge
ref_K=1/(300);                 %  300 K

% derived units
ref_kg=ref_C*ref_V*ref_s^2/(ref_m)^2;  %  kg
ref_A=ref_C/ref_s;                     %  A

%  Constants
h_bar=1.05457173*10^(-34)*ref_m^2*ref_kg/ref_s;      %  irreducible planck constant
m_e=9.10938291*10^(-31)*ref_kg;                      %  electron mass
charge=1;                                            %  electron charge
epsilon0=8.85418782*10^(-12)*ref_C/ref_V/(ref_m);    %  permittivity of air
mu0=4*pi*10^(-7)*ref_V*ref_s/(ref_A*ref_m) ;         %  permeability of air
v_free=1/sqrt(epsilon0*mu0);                         %  light speed
kb=1.3806488*10^(-23)*ref_m^2*ref_kg/ref_s^2/ref_K;  %  Boltzmann constant

%  perovskite material nk/sun spectrum (280 nm-1000 nm)
load k_int
load n_int
load spectrum_s   %  AM 1.5 global sunlight spectrum
load spectrum_sd  %  AM 1.5 direct sunlight spectrum
load lambda_s     %  wavelength range

%  restriction angle array
theta_array=zeros(1,length(spectrum_s));

%  partial angular restriction
% cuoff_wavelength1=421;  %  421
% cuoff_wavelength2=721;

%  w/o angular restriction
%cuoff_wavelength1=10000;
cuoff_wavelength2=length(spectrum_s)+1;

% %  full angular restriction
% cuoff_wavelength1=0;
% cuoff_wavelength2=10000;

% for angular restriction
for m=1:length(spectrum_s)
    if (cuoff_wavelength1<m & m<cuoff_wavelength2)
        theta_array(m)=0;
    else
        theta_array(m)=pi/2;
    end
end

%  absorption coef.
for m=1:length(spectrum_s)
    alpha(m)=2*(2*pi/lambda_s(m))*k_int(m);
    abs1(m)=1-exp(-2*L*alpha(m));  %  flat+reflector
    %abs2(m)=alpha(m)/(alpha(m)+sin(theta_array(m))^2/(4*n_int(m)^2*L));  %  4n^2 limit (texture+reflector)
end


%  normalization
spectrum_s=spectrum_s*(ref_V*ref_C/ref_s)/ref_m^2;
spectrum_sd=spectrum_sd*(ref_V*ref_C/ref_s)/ref_m^2;

%  photocurrent
J_gen=0;

for m=1:length(spectrum_s)
    if (cuoff_wavelength1<m & m<cuoff_wavelength2)
        J_gen=J_gen+abs1(m)*spectrum_sd(m)/(h_bar*2*pi*v_free/lambda_s(m));  %  direct AM 1.5
    else
        J_gen=J_gen+abs1(m)*spectrum_s(m)/(h_bar*2*pi*v_free/lambda_s(m));   %  global AM 1.5
    end
end
J_gen=J_gen*charge;
J_gen=J_gen/(ref_A/ref_m^2);

%  dark current
T=(300)*ref_K;
for m=1:length(spectrum_s)
    sunx(m)=(h_bar*2*pi)*8*pi*(v_free^2/lambda_s(m)^5)/(exp((h_bar*2*pi*v_free/lambda_s(m)-charge*V)/(kb*T))-1);
    sunx0(m)=(h_bar*2*pi)*8*pi*(v_free^2/lambda_s(m)^5)/(exp((h_bar*2*pi*v_free/lambda_s(m))/(kb*T))-1);
end

J0=0;
for m=1:length(spectrum_s)
    J0=J0+abs1(m)*(sunx(m)-sunx0(m))*sin(theta_array(m))^2/(h_bar*2*pi*v_free/lambda_s(m))/4;
end
J0=J0*charge;
J0=J0/(ref_A/ref_m^2);

%  SRH recombination
J1=0;

%  pervoskite
nr=10^10/(0.01*ref_m)^3/(ref_s);  %  nonradiative recombination rate
%nr=0;
for m=1:length(spectrum_s)
    J1=J1+nr*L*exp(0.5*charge*V/(kb*T));
end

J1=J1*charge;
J1=J1/(ref_A/ref_m^2);

%  V-J Curve
JJ=J1+J0-J_gen;








